<?php

namespace CleantalkSP\SpbctWP\AdminBannersModule\AdminBanners;

use CleantalkSP\SpbctWP\AdminBannersModule\AdminBannersHandler;
use CleantalkSP\SpbctWP\FileEditorDisabler\FileEditorDisabler;

class AdminBannerWpConfigError extends AdminBannerAbstract
{
    const NAME = 'wpconfig_error';

    /**
     * @param AdminBannersHandler $banners_handler
     *
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function __construct(AdminBannersHandler $banners_handler)
    {
        $this->banner_id = $this->prefix . self::NAME . '_' . $banners_handler->getUserId();
    }

    protected function needToShow()
    {
        return (
            !get_option('spbc_hide_wpconfig_error_banner') &&
            (defined('SPBC_WPCONFIG_ERROR') && constant('SPBC_WPCONFIG_ERROR')) &&
            current_user_can('administrator') &&
            !$this->isDismissed()
        );
    }

    protected function display()
    {
        $error = defined('SPBC_WPCONFIG_ERROR') && constant('SPBC_WPCONFIG_ERROR')
            ? FileEditorDisabler::getErrorMessage((string)SPBC_WPCONFIG_ERROR)
            : FileEditorDisabler::getErrorMessage('config_common_error');
        ?>
        <div
            class="spbc-notice um-admin-notice notice notice-error is-dismissible"
            id="<?php echo esc_attr($this->banner_id); ?>"
            style="position: relative;padding-bottom: 1em;"
        >
            <h3><?php echo esc_html__($error); ?></h3>
        </div>
        <?php
    }
}
