<?php

namespace CleantalkSP\SpbctWP\AdminBannersModule\AdminBanners;

use CleantalkSP\SpbctWP\AdminBannersModule\AdminBannersHandler;

class AdminBannerFileEditorDashboard extends AdminBannerAbstract
{
    const NAME = 'file_editor_dashboard';

    /**
     * Banner ID
     *
     * @var string
     */
    protected $banner_id;

    /**
     * @param AdminBannersHandler $banners_handler
     *
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function __construct(AdminBannersHandler $banners_handler)
    {
        $this->banner_id = $this->prefix . self::NAME . '_' . $banners_handler->getUserId();
    }

    protected function needToShow()
    {
        global $spbc, $pagenow;

        $no_wpconfig_error = !defined('SPBC_WPCONFIG_ERROR') || !constant('SPBC_WPCONFIG_ERROR');
        return (
            isset($spbc->settings['misc_disable_file_editor']) &&
            $spbc->settings['misc_disable_file_editor'] == 2 &&
            $no_wpconfig_error &&
            is_admin() &&
            $pagenow === 'index.php' &&
            current_user_can('administrator') &&
            !$this->isDismissed()
        );
    }

    protected function display()
    {
        ?>
        <div class="notice spbc-notice notice-warning is-dismissible" id="<?php echo esc_attr($this->banner_id); ?>" style="padding-bottom: 1em;">
            <h3><?php echo esc_html__("Critical Infection Detected - File Editor Access Blocked", 'security-malware-firewall'); ?></h3>
            <p>
                <?php echo esc_html__("We've detected malware classified as Critical. To reduce the risk of exploitation, CleanTalk disabled the WordPress File Editor.", 'security-malware-firewall'); ?>
            </p>
            <p>
                <?php echo esc_html__("This automatic protection helps prevent attackers from modifying theme or plugin code directly from the admin area.", 'security-malware-firewall'); ?>
            </p>
            <p style="color: #888; font-size: 0.95em; margin-top: 1em;">
                <?php echo esc_html__("The protection will be removed automatically when all critical issues are resolved — unless you've manually enabled the block.", 'security-malware-firewall'); ?>
            </p>
        </div>
        <?php
    }
}