<?php

namespace CleantalkSP\SpbctWP\AdminBannersModule\AdminBanners;

use CleantalkSP\SpbctWP\AdminBannersModule\AdminBannersHandler;

class AdminBannerCriticalFilesWarning extends \CleantalkSP\SpbctWP\AdminBannersModule\AdminBanners\AdminBannerAbstract
{
    /**
     * Hiding time in days
     */
    const HIDING_TIME = 30;

    /**
     * Simple Banner Name, most be unique
     */
    const NAME = 'critical_files_warning';

    /**
     * Data for template
     *
     * @var array $template_data
     */
    private $template_data;

    /**
     * @var AdminBannersHandler
     */
    private $banners_handler;

    /**
     * @param AdminBannersHandler $banners_handler
     *
     * @psalm-suppress PossiblyUnusedMethod
     */
    public function __construct(AdminBannersHandler $banners_handler)
    {
        $this->banners_handler = $banners_handler;
        $this->banner_id       = $this->prefix . $this::NAME . '_' . $this->banners_handler->getUserId();
        $onclick = 'spbcHighlightCriticalFilesNotice(true);';
        $this->template_data = array(
            'button'   => '<input type="button" class="button button-primary" value="'
                        . esc_html__('Check Infection', 'security-malware-firewall')
                        . '" onclick="' . $onclick . '"/>',
            'link'     => 'options-general.php?page=spbc&spbc_tab=scanner&highlight_critical_files=1',
            'title'    => esc_html__('Critical Warning: Potential Malware Infection!', 'security-malware-firewall'),
            'subtitle' => esc_html__('CleanTalk Security scans indicate a high probability of malware infection. There\'s a strong indication that your website is infected with malware.', 'security-malware-firewall'),
        );
    }

    /**
     * do I need to show a banner?
     *
     * @return bool
     */
    protected function needToShow()
    {
        if (
            ! $this->banners_handler->spbc->data['wl_mode_enabled'] &&
            $this->banners_handler->spbc->key_is_ok &&
            $this->banners_handler->spbc->notice_critical_files_warning &&
            ! $this->isDismissed() &&
            current_user_can('administrator')
        ) {
            $this->banners_handler->spbc->error_delete_all('save');

            return true;
        }

        return false;
    }

    /**
     * Print HTML of banner
     */
    protected function display()
    {
        $data = $this->template_data;
        $is_dismissible = !$this->banners_handler->isOnSpbcSettingsPage() ? 'is-dismissible' : '';
        ?>
        <div
            class="spbc-notice um-admin-notice notice notice-error <?php echo esc_html($is_dismissible) ?>"
            id="<?php echo $this->banner_id; ?>"
            style="position: relative;padding-bottom: 1em;"
        >
            <h3><?php echo $data['title']; ?></h3>
            <h4 style="color: gray;"><?php echo $data['subtitle']; ?></h4>
            <?php echo $data['button']; ?>
        </div>
        <?php
    }
}
